@include('label.index')

<div class="ulz-datetime">

    <div class="ulz-grid">
        <div class="ulz-col-12 ulz--col-year ulz-mb-1">
            <p class="ulz-weight-700 ulz-mb-1">{{ $strings->year }}</p>
            <input

                type="text"
                name="{{ $id }}[year]"
                value="{{ isset( $value['year'] ) ? $value['year'] : '' }}"
                placeholder="{{ date_i18n('Y') }}">
        </div>
        <div class="ulz-col-12 ulz--col-month ulz-mb-1">
            <p class="ulz-weight-700 ulz-mb-1">{{ $strings->month }}</p>
            <div class="ulz-select">
                <select name="{{ $id }}[month]">
                    <option value="">{{ $strings->select_month }}</option>
                    @foreach( $months as $month_key => $month_name )
                        <option value="{{ $month_key }}" @if( isset( $value['month'] ) && $value['month'] == $month_key ) selected="selected" @endif>{{ sprintf( '%02d', $month_key ) }} - {{ $month_name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="ulz-col-12 ulz--col-day ulz-mb-1">
            <p class="ulz-weight-700 ulz-mb-1">{{ $strings->day }}</p>
            <input

                type="text"
                name="{{ $id }}[day]"
                value="{{ isset( $value['day'] ) ? $value['day'] : '' }}"
                placeholder="{{ date_i18n('d') }}">
        </div>
    </div>

    <div class="ulz-grid">
        <div class="ulz-col-6 ulz--col-hour ulz-mb-1">
            <p class="ulz-weight-700 ulz-mb-1">{{ $strings->hour }}</p>
            <input

                type="text"
                name="{{ $id }}[hour]"
                value="{{ isset( $value['hour'] ) ? $value['hour'] : '' }}"
                placeholder="{{ date_i18n('H') }}">
        </div>
        <div class="ulz-col-6 ulz--col-minute ulz-mb-1">
            <p class="ulz-weight-700 ulz-mb-1">{{ $strings->minute }}</p>
            <input

                type="text"
                name="{{ $id }}[minute]"
                value="{{ isset( $value['minute'] ) ? $value['minute'] : '' }}"
                placeholder="{{ date_i18n('i') }}">
        </div>
    </div>



</div>
